// phyllotactic spiralMod01.fsh
//https://www.shadertoy.com/view/fssyWr

// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed* 0.3141592
#define iResolution u_WindowSize

#define iMouse AUTO_MOUSE
#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define iMouse vec4(0.0,0.0, 0.0,0.0)
#ifdef GL_ES
precision mediump float;
#endif
vec4 texture2D_Fract(sampler2D sampler,vec2 P)
 { return texture2D(sampler,fract(P));
 }
uniform sampler2D iChannel0;
//uniform vec2 iResolution;

//THETA is the golden angle in radians: 2 * PI * ( 1 - 1 / PHI )
#define THETA 2.399963229728653 

vec2 spiralPosition(float t)
{
    float angle = t * THETA; 
    float radius = sqrt( t ) ;
    return vec2( radius * cos( angle ) + .5, radius * sin( angle ) + .5 );
}

void main(void)
//void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
    vec2 uv = ( gl_FragCoord.xy - .25 * iResolution.xy*2 ) / iResolution.y *992.;
    //vec2 uv = ( gl_FragCoord - .25 * iResolution.x*2 ) / iResolution.y * 1024.;
    float a = 0.;
    float d = 100.;
    for(int i = 0; i < 256; i++)
    {
        vec2 pointDist = uv - spiralPosition( float(i) ) * 20.;
        d = min( dot( pointDist, pointDist ), d );
    }
    d = 5.-sqrt( d );
    gl_FragColor = vec4( d,d,d, 1. );
}